/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;

public final class Util {
    public static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] monthsName = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final int SPECIFIED_TIME = 0;
    public static final int SPECIFIED_DEPTH = 1;
    public static final int DEPTH_AT_TIME = 10;
    public static final int TIME_TO_DEPTH = 11;
    public static final int AMOUNT_PASSING_DEPTH = 12;
    public static final int GWHAZARD = 13;
    public static final int RAINFALL = 14;
    public static final int ET = 15;
    public static final int IRRIGATION = 16;
    public static final int DRAINAGE = 17;
    public static final double NODATA = -999.0;
    public static final int MIN = 100;
    public static final int MAX = 101;
    public static final int MEDIAN = 102;
    public static final int SPECIFIC_YEAR = 103;
    public static final int YEARS_EXCEEDED = 104;
    public static final int POE = 105;
    public static final int FIRST_YEAR = 1978;
    public static final int LAST_YEAR = 1987;

    public static String formatDouble(double d, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            d *= 10.0;
        }
        String string = String.valueOf((long)(Math.abs(d) + 0.5));
        while (string.length() <= n) {
            string = "0" + string;
        }
        String string2 = string.substring(0, string.length() - n);
        if (string2.length() == 0) {
            string2 = string2 + "0";
        }
        String string3 = string.substring(string.length() - n);
        String string4 = d < 0.0 ? "-" : "";
        string = n > 0 ? string4 + string2 + "." + string3 : string4 + string2;
        if (d < 0.0) {
            string4 = "-";
        }
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    public static final Choice populateMonth(Choice choice) {
        choice = new Choice();
        choice.addItem("January");
        choice.addItem("February");
        choice.addItem("March");
        choice.addItem("April");
        choice.addItem("May");
        choice.addItem("June");
        choice.addItem("July");
        choice.addItem("August");
        choice.addItem("September");
        choice.addItem("October");
        choice.addItem("November");
        choice.addItem("December");
        return choice;
    }

    public static final Choice populateDaysInMonth(int n, Choice choice) {
        choice = new Choice();
        for (int i = 0; i < daysInMonth[n - 1]; ++i) {
            choice.addItem("" + (i + 1));
        }
        return choice;
    }

    public static int getMonth(int n) {
        for (int i = 0; i < 12; ++i) {
            if (n <= daysInMonth[i]) {
                return i + 1;
            }
            n -= daysInMonth[i];
        }
        return -1;
    }

    public static int getDay(int n) {
        for (int i = 0; i < 12; ++i) {
            if (n <= daysInMonth[i]) {
                return n;
            }
            n -= daysInMonth[i];
        }
        return -1;
    }

    public static final String getMonthName(int n) {
        return monthsName[n - 1];
    }

    public static final int getDayOfYear(int n, int n2) {
        int n3 = n2;
        for (int i = 1; i < n; ++i) {
            n3 += daysInMonth[i - 1];
        }
        return n3;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    public static int timeLag(int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = n; i < n3; ++i) {
            if (Util.isLeapYear(i)) {
                n5 += 366;
                continue;
            }
            n5 += 365;
        }
        return n5 += n4 - n2;
    }

    public static double minimum(double[][] dArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        double d = -999.0;
        for (n6 = n; n6 <= n2 && d == -999.0; ++n6) {
            for (n5 = n3; n5 <= n4 && d == -999.0; ++n5) {
                if (dArray[n6][n5] == -999.0) continue;
                d = dArray[n6][n5];
            }
        }
        for (n6 = n; n6 <= n2; ++n6) {
            for (n5 = n3; n5 <= n4; ++n5) {
                if (dArray[n6][n5] == -999.0 || !(dArray[n6][n5] < d)) continue;
                d = dArray[n6][n5];
            }
        }
        return d;
    }

    public static double maximum(double[][] dArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        double d = -999.0;
        for (n6 = n; n6 <= n2 && d == -999.0; ++n6) {
            for (n5 = n3; n5 <= n4 && d == -999.0; ++n5) {
                if (dArray[n6][n5] == -999.0) continue;
                d = dArray[n6][n5];
            }
        }
        for (n6 = n; n6 <= n2; ++n6) {
            for (n5 = n3; n5 <= n4; ++n5) {
                if (dArray[n6][n5] == -999.0 || !(dArray[n6][n5] > d)) continue;
                d = dArray[n6][n5];
            }
        }
        return d;
    }

    public static double median(double[][] dArray, int n, int n2, int n3, int n4) {
        int n5;
        double[] dArray2 = new double[30];
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            for (int i = n3; i <= n4; ++i) {
                dArray2[n6] = dArray[n5][i];
                System.out.println("median original " + n6 + Util.formatDouble(dArray2[n6], 2, 10));
                ++n6;
            }
        }
        Util.sortDouble(dArray2, n6);
        for (n5 = 0; n5 < n6; ++n5) {
            System.out.println("sorted " + n6 + Util.formatDouble(dArray2[n5], 2, 10));
        }
        System.out.println("k/2=" + n6 / 2 + Util.formatDouble(dArray2[n6 / 2], 2, 10));
        if (n6 % 2 == 1) {
            return dArray2[n6 / 2 + 1];
        }
        return (dArray2[n6 / 2] + dArray2[n6 / 2 + 1]) / 2.0;
    }

    public static void sortDouble(double[] dArray, int n) {
        double d = dArray[0];
        int n2 = 1;
        for (int i = 0; i < n && n2 > 0; ++i) {
            n2 = 0;
            for (int j = 1; j < n - i; ++j) {
                if (!(dArray[j - 1] < dArray[j])) continue;
                d = dArray[j];
                dArray[j] = dArray[j - 1];
                dArray[j - 1] = d;
                ++n2;
            }
        }
    }
}

