function [image_uint8,image_binary,percent_canopy,handles] = applyValues(handles)
%%APPLYVALUES analyzes and displays images when the user refreshes settings.
%
% Inputs 
%       handles = handles strcuture from canopeo.m
%
% Outputs
%       image_uint8 = original image, 8-bit unsigned integer format.
%       image_binary = classified image (Black and white)
%       percent_canopy = Percent green canopy cover (%).
%
% Andres Patrignani and Tyson Ochsner, Dec 2014.

% Determine current file extension
if ismember(lower(handles.input_ext),lower({'.AVI', '.WMV', '.MPEG', '.MP4','.MOV'}))
    xyloObj = VideoReader(handles.fullfilenames{handles.k,1});
    mov.cdata = read(xyloObj, handles.i); % mov is the structure that stores the extracted frames.
    image_uint8 = mov.cdata;
else
    image_uint8 = imread(handles.fullfilenames{handles.i,1});
    % Handle images with alpha channel.
    if size(image_uint8,3)==4
        image_uint8 = image_uint8(:,:,1:3);
    end
    
end
[image_binary,percent_canopy] = imageAnalysis(image_uint8,handles); % Process images.