function [] = exportFile(canopycover,canopy_stats,handles,filenames_frame)
%%export_file writes output data in text file with .dat extension.

if strcmpi(handles.output_ext,'.txt') 
    
    [RGratio,BGratio,noise] = ratios(handles); % Get ratios, noise from handles structure
    currentDir = pwd();   
    cd(handles.dirname_output);
    
    % Create export table for videos
    canopycover = num2cell(canopycover); % matrix to cell array
    var_header = {'Red Ratio';'Blue Ratio';'Noise Reduction'};
    var_input = [RGratio; BGratio; noise];
    var_input = num2cell(var_input);
    date_analysis = datestr(now(),30); %ISO 8601 format. 
    
    % Video
    if  ismember(lower(handles.input_ext),lower(handles.video_ext))  
        
        output_matrix = [var_header, var_input;...
                    {'Files path:'}, {handles.dirname_input};...
                    {'Date'}, {date_analysis};...
                    {'Images'}, {'Green canopy cover(%)'};...
                    filenames_frame, canopycover ];
        save_output(handles.filename_output, output_matrix); % output_matrix with all frames
        
        summary_matrix = [var_header, var_input, cell(3,2);...
                         {'Files path:'}, {handles.dirname_input}, {''}, {''};...
                         {'Date'}, {date_analysis}, {''}, {''};...
                         {'Video Name'}, {'Mean green canopy cover (%)'}, {'Stdev (%)'}, {'Min. Sample Size'};...
                         handles.filenames canopy_stats];
        save_summary_output([handles.filename_output_noext,'_summary',handles.output_ext], summary_matrix); % summary_matrix with stats for each video
    
    % Images    
    else
        output_matrix = [var_header, var_input;...
                    {'Files path:'}, {handles.dirname_input};...
                    {'Date'}, {date_analysis};...
                    {'Images'}, {'Green canopy cover(%)'};...
                    handles.filenames, canopycover ];
        save_output(handles.filename_output, output_matrix); % output_matrix with all images/frames
    end
    
    cd(currentDir); % Go back to the directory where the user was at the time of running Canopeo.
else
    catchError(handles)
end