function varargout = canopeo(varargin)

% --- Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @canopeo_OpeningFcn, ...
                   'gui_OutputFcn',  @canopeo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

% Andres Patrignani and Tyson Ochsner, Dec 2014. 


% --- Executes just before canopeo is made visible.
function canopeo_OpeningFcn(hObject, eventdata, handles, varargin)

%white = imread('white.jpg'); imagesc(white); % Import white image to cover axes.
%axes(handles.binari),imshow(white);drawnow;
axes(handles.binari)
set(handles.binari,'XTickLabel',{''},'XTick',[],'YTickLabel',{''},'YTick',[]); drawnow

axes(handles.original)
set(handles.original,'XTickLabel',{''},'XTick',[],'YTickLabel',{''},'YTick',[]); drawnow

% Initialize accpeted file formats
handles.image_ext = {'.TIFF', '.TIF', '.JPEG', '.JPG', '.PNG'};
handles.video_ext = {'.AVI', '.WMV', '.MPEG', '.MP4', '.MOV'};
handles.input_ext_switch = 0;
handles.output_ext_switch = 0;

% Initialize input and output checks
handles.input_filename_exists = false;
handles.output_filename_exists = false;


% Choose default command line output for canopeo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = canopeo_OutputFcn(hObject, eventdata, handles) 
varargout{1} = handles.output;

%#function pushbuttoninput_Callback
% --- Executes on button press in pushbuttoninput.
function pushbuttoninput_Callback(hObject, eventdata, handles)

try
    [filenames, handles.dirname_input] = uigetfile (...
        {'*.TIFF;*.TIF;*.JPEG;*.JPG;*.PNG;*.tif;*.tiff;*.jpeg;*.jpg;*.png','Images (*.jpg, *.tif, *.png)'; ...
         '*.AVI;*.MPEG;*.MPEG4;*.WMV;*.avi;*.wmv;*.mpg4;*.mpeg4;*.MP4;*.MOV','Videos (*.avi, *.mpeg, *.wmv, *.mpg4, *.mov)'}...
         , 'MultiSelect', 'on'); % Define supported files.  '*.*','All files (*.*)'}
   
    % Check user inputs
    if ~ischar(filenames) && ~iscell(filenames) % Check case where user closes window without selecting any file. 
       return
    elseif ischar(filenames) % If array is char, then convert to cell array.
        filenames = cellstr(filenames);
        handles.input_filename_exists = true;
    end

    % Update status bar
    set(handles.statusbox,'String','Reading file names...'); drawnow
    
    % Define handles file name.
    handles.numfiles = length(filenames);  % Count number of files
    handles.filenames = []; % Erase pre-existing filenames
    handles.filenames = filenames'; % Filename without the directory path
    handles.fullfilenames = []; % Erase pre-existing fullfilenames array
    for n = 1:handles.numfiles 
        handles.fullfilenames{n,1} = fullfile(handles.dirname_input, filenames{1,n});
    end
    
    % Define input extension
    [~, ~, input_ext] = fileparts(filenames{1,1});
    handles.input_ext = cellstr(input_ext);
    
    % Initialize image or frame count.
    handles.i = 1; % for image filenames
    handles.k = 1; % for video filenames
    handles.imageCounter = 1; 

    % Writes input directory in the text box "input_string".
    %WrapInputString = textwrap(handles.input_string,cellstr(dirname_input)); 
    %WrapInputString = char(WrapInputString);
    if length(handles.dirname_input) > 50
        set(handles.input_string,'String',['...',handles.dirname_input(end-50:end)]);  
    else
        set(handles.input_string,'String',handles.dirname_input);  
    end
    
    % Update GUI.
    guidata(hObject, handles); 

   %% Code to analyze and display first image or video frame.
    % Check for type of input files (videos or images).  
     if ismember(lower(handles.input_ext),lower(handles.video_ext))     
               for k = 1
                   handles.xyloObj = VideoReader(handles.fullfilenames{k,1}); % Read video file .AVI or .MPEG.
                   handles.videoFrames = handles.xyloObj.NumberOfFrames;
                   mov(k).cdata = read(handles.xyloObj, k); % mov is the structure that stores the extracted frames.
                   image_uint8 = mov(k).cdata; % taking current video from structure into a normal array so that imageAnalysis can process it.
                   [image_binary, percent_canopycover] = imageAnalysis(image_uint8, handles);
               end
         axes(handles.original),imshow(image_uint8),drawnow
         axes(handles.binari),imshow(image_binary), drawnow;
         set(handles.ccbox,'String', num2str(percent_canopycover(k,1))); 
         set(handles.imageCounterBox,'String',[num2str(handles.imageCounter),'/',num2str(handles.videoFrames)])   
     elseif ismember(lower(handles.input_ext),lower(handles.image_ext))    
        for k = 1 % Display first image of the entire input set as default.  
            image_uint8 = imread(handles.fullfilenames{k,1});
            
            % Handle images with alpha channel.
            if size(image_uint8,3)==4
                image_uint8 = image_uint8(:,:,1:3);
            end
            
            [image_binary, percent_canopy] = imageAnalysis(image_uint8, handles); % Function to calculate percent_canopy cover in photos
            handles.cc = percent_canopy; % Update percent_canopy cover handle
        end
        axes(handles.original),imshow(image_uint8),drawnow
        axes(handles.binari),imshow(image_binary), drawnow;
        set(handles.ccbox,'String', num2str(handles.cc)); % Update percent_canopy cover text box on GUI interface
        set(handles.imageCounterBox,'String',[num2str(handles.imageCounter),'/',num2str(handles.numfiles)]); % Write in the imageCounterBox
        drawnow
     else 
         catchError(handles)
     end
    warning off
    handles.input_ext_switch = 1;
    set(handles.statusbox,'String','Input files loaded');
catch
     catchError(handles)
end
     
guidata(hObject, handles);

%#function pushbuttonoutput_Callback
% --- Executes on button press in pushbuttonoutput.
function pushbuttonoutput_Callback(hObject, eventdata, handles)
handles.output_ext = '.txt';
[filename_output, dirname_output] = uiputfile({['*',handles.output_ext]},'Save file');
[~,filename_output_noext] = fileparts(filename_output); 

if filename_output == 0
   set(handles.output_string,'String','Select output directory');
   return
else
    handles.dirname_output = dirname_output;
    handles.filename_output = filename_output;
    handles.filename_output_noext = filename_output_noext;
    handles.fullfileoutput = strcat(dirname_output, filename_output);
    if length(handles.fullfileoutput) > 50
        set(handles.output_string,'String',['...',handles.fullfileoutput(end-50:end)]); % Writes the output file name into the text box "output_string".
    else
        set(handles.output_string,'String',handles.fullfileoutput);  
    end
    handles.output_filename_exists = true;
end

% Define output extension
[~, ~, out_ext] = fileparts(filename_output);
handles.selected_output_ext = out_ext;
if ~ismember(lower(out_ext), lower({handles.output_ext}))
    catchError(handles)
end

handles.output_ext_switch = 1;
set(handles.statusbox,'String','Output file name successfully set');

guidata(hObject, handles); % Update GUI.



%#function pushbuttonrun_Callback
% --- Executes on button press in togglebuttonrun.
function togglebuttonrun_Callback(hObject, eventdata, handles)

try 
   assert(isfield(handles,'input_ext')) 
   assert(isfield(handles,'output_ext')) 
   tic; % Start timing code.

   % Initialize counters.
   % n tracks number of videos.
   % k and a track the number of frames.
   
   t = 0;
   j = 0;  % Video files counter 

   % Get specific video settings from user 
   trim_initial = str2double(get(handles.trim_initial_box,'String'));
   trim_last = str2double(get(handles.trim_last_box,'String')); % Remove last frames of video.
   stepFrame = str2double(get(handles.step_box,'String'));

   % Check Video files
   if ismember(lower(handles.input_ext),lower(handles.video_ext))
       for i = 1:handles.numfiles
           handles.i = i;
           j = j + 1; % Video file counter.
           xyloObj = VideoReader(handles.fullfilenames{i,1}); % Read video file .AVI or .MPEG.
           handles.totalFrames = xyloObj.NumberOfFrames;

           if i == 1
               % Check inputs
                assert(isnumeric(trim_initial) && isnumeric(trim_last) && isnumeric(stepFrame));
                assert(~isnan(trim_initial) && ~isnan(trim_last) && ~isnan(stepFrame));   
                assert(trim_initial >= 0 && trim_last >= 0 && stepFrame > 0); % stepFrame cannot be zero.
           end
           
           nFrames = handles.totalFrames - trim_last; % Obtain total number of frames.
           assert(trim_initial + trim_last < handles.totalFrames)
           a = 0; % Setting a dummy counter so that k can skip frames if deltaFrame is different than 1.
           initialFrame = 1 + trim_initial;
           
           for k = initialFrame:stepFrame:nFrames % Extract every frame from original video if 1:20:nFrames then every 1 in 20 frames are analyzed 
               if get(hObject,'Value')
                   set(hObject,'String','Stop')
                   set(handles.statusbox,'String',['Processing video:',' ',handles.filenames{i,1},'...',num2str(ceil(k/nFrames*100)),' %']); drawnow
                   a = a + 1; % Dummy counter
                   t = t + 1; % Dummy counter
                   mov(k).cdata = read(xyloObj, k); % mov is the structure that stores the extracted video frames.
                   image_uint8 = mov(k).cdata;
                   [image_binary,percent_canopy] = imageAnalysis(image_uint8, handles);               
                   filenames_frame{t,1} = [handles.filenames{i,1},' ','Frame',' #', num2str(k)]; % Read file names from structure to cell array.
                   canopy_current(a,1) = percent_canopy;
                   canopy_data(t,1) = percent_canopy;              
                   checkboxStatus1 = get(handles.ShowHideCheckbox,'Value');
                   
                   if(checkboxStatus1)
                      axes(handles.original),imshow(image_uint8),drawnow
                      pause(0.1)
                      axes(handles.binari),imshow(image_binary), drawnow; % Make axes2 the gca.
                      set(handles.ccbox,'String', num2str(canopy_data(a,1)));
                   end           
                   mov(a).cdata = []; % Delete intermediate image after processing to free memory.      
               
               else
                   set(handles.statusbox,'String','Video analysis has been cancelled'); drawnow
                   set(hObject,'String','Run'); drawnow
                   set(hObject,'Value',0); drawnow
                   return
               end
           end
               canopy_stats{i,1} = mean(canopy_current(:,1)); % Average percent_canopy cover for 1 whole video.
               canopy_stats{i,2} = std(canopy_current(:,1));
               canopy_stats{i,3} = ceil((1.96*canopy_stats{i,2}/5)^2); % Power analysis for mean within 5% green canopy cover.
               canopy_current = [];
       end    
       exportFile(canopy_data,canopy_stats,handles, filenames_frame)  % Write output video data in MS Excel.

   % Check digital image files.  
   elseif ismember(lower(handles.input_ext),lower(handles.image_ext)) 
       canopy_data = nan(handles.numfiles,1); % Pre-allocate array for speed.
       for k = 1:handles.numfiles
           
           if get(hObject,'Value')
               set(hObject,'String','Stop')
               set(handles.statusbox,'String',['Processing Images...',num2str(ceil(k/handles.numfiles*100)),' %']); drawnow
               image_uint8 = imread(handles.fullfilenames{k,1});
               
               % Handle images with alpha channel.
               if size(image_uint8,3)==4
                   image_uint8 = image_uint8(:,:,1:3);
               end
               
               [image_binary,percent_canopy] = imageAnalysis(image_uint8, handles);
               canopy_data(k,1) = percent_canopy; % moving final output to a numerical array.
               checkboxStatus1 = get(handles.ShowHideCheckbox,'Value');
               
               if(checkboxStatus1)
                  axes(handles.original),imshow(image_uint8),drawnow;
                  pause(0.2)
                  axes(handles.binari),imshow(image_binary),drawnow; % Make axes2 the gca.  
                  set(handles.ccbox,'String', num2str(canopy_data(k,1)));
               end
               
               image_uint8 = []; % delete intermediate image after processing to free memory
               image_binary = [];
           else
               set(handles.statusbox,'String','Image analysis has been cancelled')
               set(hObject,'String','Run')
               set(hObject,'Value',0)
               return
           end
       end
      set(handles.statusbox,'String','Saving file...'); drawnow
      exportFile (canopy_data, [], handles, []) % Call function exportFile to write output data in MS Excel.
   end
   elapsedTime = round(toc);
   
   if elapsedTime < 60
      timestring = [num2str(round(elapsedTime)),' seconds'];
   elseif elapsedTime >= 60 && elapsedTime < 3600
      timestring = [sprintf('%5.2f', elapsedTime/60),' minutes'];
   else
      timestring = [sprintf('%5.2f', elapsedTime/3600),' hours'];     
   end
   
   set(hObject,'String','Run')
   set(hObject,'Value',0)
   set(handles.statusbox,'String',['File saved. Analysis completed in ', ' ', timestring]); % Dsiplay message text box.
catch
    catchError(handles) 
end


% --- Executes on button press in forward_image.
function forward_image_Callback(hObject, eventdata, handles)
set(handles.statusbox,'String','Loading new image...')
try 
    handles.imageSelector = 1;
    [image_uint8,image_binary, percent_canopy, handles] = imageSelector(handles);    
    handles.cc = percent_canopy;
    set(handles.ccbox,'String', num2str(handles.cc));
    drawnow
    axes(handles.original),imshow(image_uint8),drawnow,axes(handles.binari),imshow(image_binary); % Make axes2 the gca.
    drawnow
    set(handles.statusbox,'String','Image successfully loaded.')
    if ismember(lower(handles.input_ext),lower({'.TIFF', '.TIF', '.JPEG', '.JPG', '.PNG'})) 
        set(handles.imageCounterBox,'String',[num2str(handles.imageCounter),'/',num2str(handles.numfiles)])
    else
        set(handles.imageCounterBox,'String',[num2str(handles.imageCounter),'/',num2str(handles.videoFrames)])    
    end
    guidata(hObject,handles)
catch   
    catchError(handles)
end

% --- Executes on button press in previous_image.
function previous_image_Callback(hObject, eventdata, handles)

set(handles.statusbox,'String','Loading new image...')
try 
    handles.imageSelector = 0;
    [image_uint8,image_binary, percent_canopy, handles] = imageSelector(handles);    
    handles.cc = percent_canopy;
    set(handles.ccbox,'String', num2str(handles.cc));
    drawnow
    axes(handles.original),imshow(image_uint8),drawnow,axes(handles.binari),imshow(image_binary); % Make axes2 the gca.
    drawnow
    set(handles.statusbox,'String','Image successfully loaded.')
    if ismember(lower(handles.input_ext),lower({'.TIFF', '.TIF', '.JPEG', '.JPG', '.PNG'})) 
        set(handles.imageCounterBox,'String',[num2str(handles.imageCounter),'/',num2str(handles.numfiles)])
    else
        set(handles.imageCounterBox,'String',[num2str(handles.imageCounter),'/',num2str(handles.videoFrames)])    
    end
    guidata(hObject,handles)
catch   
    catchError(handles)
end


% --- Executes when pressin Apply values button.
function update_button_Callback(hObject, eventdata, handles)
set(handles.statusbox,'String','Updating image...')
try
    [image_uint8,image_binary, percent_canopy,handles] = applyValues (handles);
    handles.cc = percent_canopy;
    set(handles.ccbox,'String', num2str(handles.cc));
    axes(handles.original),imshow(image_uint8),drawnow
    axes(handles.binari),imshow(image_binary),drawnow % Make axes2 the gca.
    set(handles.statusbox,'String','Image updated.')
    guidata(hObject,handles)
catch
    catchError(handles)
end

function r2g_box_Callback(hObject, eventdata, handles)
% If user inputs something is not a number, or if the input is less than 0
% or greater than 2, then the slider value defaults to 0
  
% --- Executes during object creation, after setting all properties.
function r2g_box_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function b2g_box_Callback(hObject, eventdata, handles)
% If user inputs something is not a number, or if the input is less than 0
% or greater than 2, then the slider value defaults to 0

% --- Executes during object creation, after setting all properties.
function b2g_box_CreateFcn(hObject, ~, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function input_string_Callback(hObject, eventdata, handles)
    input_name = get(handles.input_string,'String');
    %input_name = get(handles.pushbuttoninput,'String');
    if (isempty(input_name))
        set(handles.input_string,'String','Select input directory');
    else
        %set(handles.input_string,'String','Select input directory');
        %set(handles.input_string,'String',input_name);
    end


% --- Executes during object creation, after setting all properties.
function input_string_CreateFcn(hObject, ~, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function output_string_Callback(hObject, eventdata, handles)
output_name = get(handles.output_string,'String');
%output_name = get(handles.pushbuttonoutput,'String');
if isempty(output_name)
   set(handles.output_string,'String','Select output');
else
    set(handles.output_string,'String',output_name);
end


% --- Executes during object creation, after setting all properties.
function output_string_CreateFcn(hObject, ~, ~)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ShowHideCheckbox.
function ShowHideCheckbox_Callback(~, eventdata, handles)

function sharpness_box_Callback(~, ~, handles)

% --- Executes during object creation, after setting all properties.
function sharpness_box_CreateFcn(hObject, ~, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function noise_box_Callback(hObject, eventdata, ~)


function noise_box_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function ccbox_Callback(~, ~, ~)

% --- Executes during object creation, after setting all properties.
function ccbox_CreateFcn(hObject, ~, ~)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit9_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function edit9_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function statusbox_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function statusbox_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');

end

% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)

function trim_initial_box_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function trim_initial_box_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function step_box_Callback(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function step_box_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function trim_last_box_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function trim_last_box_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on key press with focus on togglebuttonrun and none of its controls.
function togglebuttonrun_KeyPressFcn(hObject, eventdata, handles)

function imageCounterBox_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function imageCounterBox_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit16_Callback(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function edit16_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
